/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWScenarioArrivalCycle;
import filenet.sim.api.VWScenarioArrivalOccurrence;
import filenet.sim.api.VWScenarioArrivalRecurrence;
import filenet.sim.api.VWScenarioConfiguration;
import filenet.sim.api.VWScenarioDayType;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioDurationPattern;
import filenet.sim.api.VWScenarioFieldAssignments;
import filenet.sim.api.VWScenarioFieldAssignmentsEntry;
import filenet.sim.api.VWScenarioInputField;
import filenet.sim.api.VWScenarioInputFields;
import filenet.sim.api.VWScenarioOccurrenceType;
import filenet.sim.api.VWScenarioOrderType;
import filenet.sim.api.VWScenarioOutputField;
import filenet.sim.api.VWScenarioOutputFields;
import filenet.sim.api.VWScenarioPriorityField;
import filenet.sim.api.VWScenarioPriorityType;
import filenet.sim.api.VWScenarioQueueAssignment;
import filenet.sim.api.VWScenarioQueueDefinition;
import filenet.sim.api.VWScenarioResourceDefinition;
import filenet.sim.api.VWScenarioResourcePriorityType;
import filenet.sim.api.VWScenarioResourceType;
import filenet.sim.api.VWScenarioRoleAssignment;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioShiftDefinition;
import filenet.sim.api.VWScenarioShiftType;
import filenet.sim.api.VWScenarioStepSettings;
import filenet.sim.api.VWScenarioTimeDuration;
import filenet.sim.api.VWScenarioTimeOffset;
import filenet.sim.api.VWScenarioTimeUnitType;
import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.api.VWScenarioXMLHandler;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.CEObjectInfo;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class VWXML_CUR_parser {
    VWXML_CUR_parser() {
    }

    protected static VWScenarioDefinition[] parseXPDLScenarioCollection(Element ele) throws VWException, IOException, SAXException, ParseException {
        if (!ele.getTagName().equals("fn:ScenarioDefinitions")) {
            return null;
        }
        NodeList childNodes = ele.getChildNodes();
        int numChilds = childNodes.getLength();
        if (childNodes != null && numChilds != 0) {
            Vector<VWScenarioDefinition> scenarioDefList = new Vector<VWScenarioDefinition>();
            for (int i = 0; i < numChilds; ++i) {
                Element scenarioElement;
                String verStr;
                Node aNode = childNodes.item(i);
                if (!aNode.getNodeName().equals("Scenario") || !(aNode instanceof Element) || (verStr = (scenarioElement = (Element)aNode).getAttribute("ApiVersion")) == null || verStr.equals("")) continue;
                if (verStr.equals("1.0")) {
                    VWScenarioDefinition scenarioDef = VWXML_CUR_parser.parseXMLScenario(scenarioElement);
                    if (scenarioDef == null) continue;
                    scenarioDefList.addElement(scenarioDef);
                    continue;
                }
                throw new VWException("sim.api.VWScenarioXMLHandler.VWBadXMLFileVersion", "The XML file contains an ApiVersion attribute, {0}, Which cannot be parsed by this version of the scenario API.", verStr);
            }
            if (scenarioDefList.size() > 0) {
                Object[] scenarioDefs = new VWScenarioDefinition[scenarioDefList.size()];
                scenarioDefList.copyInto(scenarioDefs);
                return scenarioDefs;
            }
        }
        return null;
    }

    protected static VWScenarioDefinition parseXMLScenario(Element ele) throws VWException, IOException, SAXException, ParseException {
        NodeList childNodes;
        if (!ele.getTagName().equals("Scenario")) {
            return null;
        }
        VWScenarioDefinition scenarioDef = new VWScenarioDefinition();
        if (ele.getAttributeNode("Name") != null) {
            scenarioDef.setName(ele.getAttribute("Name"));
        }
        if (ele.getAttributeNode("Description") != null) {
            scenarioDef.setDescription(ele.getAttribute("Description"));
        }
        if ((childNodes = ele.getChildNodes()) != null && childNodes.getLength() != 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node aNode = childNodes.item(i);
                if (aNode.getNodeName().equals("WorkFlowDefinitions")) {
                    VWXML_CUR_parser.parseXMLWorkflowDefinitions(aNode, scenarioDef);
                    continue;
                }
                if (aNode.getNodeName().equals("WorkflowProcesses")) {
                    VWXML_CUR_parser.parseXPDLWorkflowDefinitions(aNode, scenarioDef);
                    continue;
                }
                if (aNode.getNodeName().equals("ConfigurationDefinitions")) {
                    VWXML_CUR_parser.parseXMLConfigurations(aNode, scenarioDef);
                    continue;
                }
                if (aNode.getNodeName().equals("ResourceDefinition")) {
                    VWXML_CUR_parser.parseXMLResourceDefinition(aNode, scenarioDef);
                    continue;
                }
                if (aNode.getNodeName().equals("ArrivalDefinition")) {
                    VWXML_CUR_parser.parseXMLArrivalDefinition(aNode, scenarioDef);
                    continue;
                }
                if (aNode.getNodeName().equals("ActivityDefinition")) {
                    VWXML_CUR_parser.parseXMLActivityDefinition(aNode, scenarioDef);
                    continue;
                }
                if (aNode.getNodeName().equals("Options")) {
                    VWXML_CUR_parser.parseXMLOptions(aNode, scenarioDef);
                    continue;
                }
                if (!aNode.getNodeName().equals("CEObjectInfoObjects")) continue;
                VWXML_CUR_parser.parseXMLCEObjectInfoObjects(aNode, scenarioDef);
            }
        }
        return scenarioDef;
    }

    private static void parseXMLCEObjectInfoObjects(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        NodeList childNodes = ((Element)aNode).getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Element element;
                if (childNodes.item(i).getNodeType() != 1 || !(element = (Element)childNodes.item(i)).getNodeName().equals("CEObjectInfoObject")) continue;
                String sId = element.getAttribute("Id");
                String sName = element.getAttribute("Name");
                String sSymbolicName = element.getAttribute("SymbolicName");
                CEObjectInfo newCEObjectInfo = scenarioDef.createCEObjectInfo(sId, sName, sSymbolicName);
                NodeList propertyNodes = element.getChildNodes();
                if (propertyNodes != null) {
                    for (int j = 0; j < propertyNodes.getLength(); ++j) {
                        Element propertyElement;
                        if (propertyNodes.item(j).getNodeType() != 1 || !(propertyElement = (Element)propertyNodes.item(j)).getNodeName().equals("Property")) continue;
                        String sPropertyName = propertyElement.getAttribute("Name");
                        int nType = VWFieldType.stringToType(propertyElement.getAttribute("Type"));
                        boolean bIsArray = Boolean.valueOf(propertyElement.getAttribute("IsArray"));
                        newCEObjectInfo.setPropertyType(sPropertyName, nType, bIsArray);
                    }
                }
                scenarioDef.addCEObjectInfo(newCEObjectInfo);
            }
        }
    }

    protected static void parseXMLOptions(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        NodeList childNodes = ((Element)aNode).getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                if (childNodes.item(i).getNodeType() != 1) continue;
                Element element = (Element)childNodes.item(i);
                if (element.getNodeName().equals("Begin")) {
                    if (element.getAttributeNode("Type") != null && element.getAttribute("Type").equals("SPECIFIED")) {
                        scenarioDef.setStartTime(VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getNodeNamed(element, "TimeExpression")));
                        continue;
                    }
                    scenarioDef.setStartTime(null);
                    continue;
                }
                if (element.getNodeName().equals("End")) {
                    if (element.getAttributeNode("Type") != null && element.getAttribute("Type").equals("SPECIFIED")) {
                        scenarioDef.setEndTime(VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getNodeNamed(element, "TimeExpression")));
                        continue;
                    }
                    scenarioDef.setEndTime(null);
                    continue;
                }
                if (element.getNodeName().equals("Seed")) {
                    if (element.getAttributeNode("Type") == null) continue;
                    if (element.getAttribute("Type").equals("SPECIFIED") && element.getAttributeNode("Value") != null) {
                        scenarioDef.setSeed(new Integer(element.getAttribute("Value")));
                        continue;
                    }
                    scenarioDef.setSeed(null);
                    continue;
                }
                if (element.getNodeName().equals("Animate")) {
                    if (element.getAttributeNode("Value") == null) continue;
                    scenarioDef.setAnimationEnabled(element.getAttribute("Value").equals("ON"));
                    continue;
                }
                if (element.getNodeName().equals("Publish")) {
                    if (element.getAttributeNode("Value") == null) continue;
                    scenarioDef.setCollectAnalysisData(element.getAttribute("Value").equals("DB"));
                    continue;
                }
                if (!element.getNodeName().equals("ResourcePriority") || element.getAttributeNode("Value") == null) continue;
                scenarioDef.setResourcePriority(VWScenarioResourcePriorityType.stringToType(element.getAttribute("Value")));
            }
        }
    }

    protected static void parseXMLResourceDefinition(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        VWScenarioShiftDefinition[] shifts;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Map shiftRoles = Collections.synchronizedMap(new HashMap());
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node theNode = childNodes.item(i);
                if (theNode.getNodeName().equals("Resources")) {
                    shiftRoles = VWXML_CUR_parser.parseXMLResources(theNode, scenarioDef);
                    continue;
                }
                if (theNode.getNodeName().equals("Roles")) {
                    VWXML_CUR_parser.parseXMLRoles(theNode, scenarioDef);
                    continue;
                }
                if (!theNode.getNodeName().equals("Shifts")) continue;
                VWXML_CUR_parser.parseXMLShifts(theNode, scenarioDef);
            }
        }
        if ((shifts = scenarioDef.getShifts()) != null) {
            for (int i = 0; i < shifts.length; ++i) {
                if (!shiftRoles.containsKey(shifts[i].getName())) continue;
                shifts[i].setRoleAssignments((Map)shiftRoles.get(shifts[i].getName()));
            }
        }
    }

    protected static Map parseXMLResources(Node resourcesNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException {
        if (resourcesNode.getNodeType() != 1) {
            return null;
        }
        Map shifts = Collections.synchronizedMap(new HashMap());
        Element resourcesElement = (Element)resourcesNode;
        NodeList childNodes = resourcesElement.getChildNodes();
        if (childNodes != null) {
            String resourceName = null;
            int type = 1;
            int qty = 0;
            double cost = 0.0;
            float performance = 1.0f;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node resourceNode = childNodes.item(i);
                if (!resourceNode.getNodeName().equals("Resource")) continue;
                Element resourceElement = (Element)resourceNode;
                if (resourceElement.getAttributeNode("Name") != null) {
                    resourceName = resourceElement.getAttribute("Name");
                }
                if (resourceElement.getAttributeNode("DisplayName") != null) {
                    resourceElement.getAttribute("DisplayName");
                }
                if (resourceElement.getAttributeNode("Id") != null) {
                    Integer.parseInt(resourceElement.getAttribute("Id"));
                }
                if (resourceElement.getAttributeNode("Type") != null) {
                    type = VWScenarioResourceType.stringToType(resourceElement.getAttribute("Type"));
                }
                if (resourceElement.getAttributeNode("Quantity") != null) {
                    qty = Integer.parseInt(resourceElement.getAttribute("Quantity"));
                }
                if (resourceElement.getAttributeNode("Cost") != null) {
                    cost = Double.parseDouble(resourceElement.getAttribute("Cost"));
                }
                if (resourceElement.getAttributeNode("Performance") != null) {
                    performance = Float.parseFloat(resourceElement.getAttribute("Performance"));
                }
                VWScenarioResourceDefinition resourceDef = null;
                if (!resourceName.equals("F_System")) {
                    resourceDef = scenarioDef.createResource(resourceName, type, qty, cost, performance);
                }
                NodeList resourceChildNodes = resourceNode.getChildNodes();
                for (int j = 0; j < resourceChildNodes.getLength(); ++j) {
                    Node resourceChildNode = resourceChildNodes.item(j);
                    if (!resourceChildNode.getNodeName().equals("RoleAssignments")) continue;
                    NodeList roleNodes = resourceChildNode.getChildNodes();
                    String roleName = null;
                    String shiftName = null;
                    float rolePerformance = 1.0f;
                    for (int k = 0; k < roleNodes.getLength(); ++k) {
                        Node roleNode = roleNodes.item(k);
                        if (!roleNode.getNodeName().equals("RoleAssignment")) continue;
                        Element roleElement = (Element)roleNode;
                        if (roleElement.getAttributeNode("Shift") == null) {
                            throw new VWException("sim.api.VWScenarioXMLHandler.MissingShiftNameAttribute", "Resource {0} is missing required shift name for role assignment {1}.", resourceName, roleName);
                        }
                        shiftName = roleElement.getAttribute("Shift");
                        if (roleElement.getAttributeNode("Role") != null) {
                            roleName = roleElement.getAttribute("Role");
                        }
                        if (roleElement.getAttributeNode("Index") != null) {
                            Integer.parseInt(roleElement.getAttribute("Index"));
                        }
                        if (roleElement.getAttributeNode("Performance") != null) {
                            rolePerformance = Float.parseFloat(roleElement.getAttribute("Performance"));
                        }
                        if (!shifts.containsKey(shiftName)) {
                            shifts.put(shiftName, Collections.synchronizedMap(new HashMap()));
                        }
                        VWScenarioRoleAssignment roleAssignment = null;
                        if (((Map)shifts.get(shiftName)).containsKey(roleName)) {
                            roleAssignment = (VWScenarioRoleAssignment)((Map)shifts.get(shiftName)).get(roleName);
                        } else {
                            roleAssignment = new VWScenarioRoleAssignment(roleName);
                            ((Map)shifts.get(shiftName)).put(roleName, roleAssignment);
                        }
                        if (resourceDef == null) continue;
                        roleAssignment.createResourceAssignment(resourceDef, rolePerformance);
                    }
                }
            }
        }
        return shifts;
    }

    protected static void parseXMLRoles(Node rolesNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException {
        if (rolesNode.getNodeType() != 1) {
            return;
        }
        Element rolesElement = (Element)rolesNode;
        NodeList childNodes = rolesElement.getChildNodes();
        if (childNodes != null) {
            VWScenarioRoleDefinition roleDef = null;
            String roleName = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node roleNode = childNodes.item(i);
                if (!roleNode.getNodeName().equals("Role")) continue;
                Element roleElement = (Element)roleNode;
                if (roleElement.getAttributeNode("Name") != null) {
                    roleName = roleElement.getAttribute("Name");
                }
                roleDef = scenarioDef.createRole(roleName);
                Element queueAssignments = (Element)VWScenarioXMLHandler.getNodeNamed(roleElement, "QueueAssignments");
                if (queueAssignments == null) continue;
                NodeList queueNodes = queueAssignments.getChildNodes();
                String queueName = null;
                int priority = -1;
                int index = -1;
                for (int j = 0; j < queueNodes.getLength(); ++j) {
                    NodeList fieldNodes;
                    if (!queueNodes.item(j).getNodeName().equals("QueueAssignment")) continue;
                    Element queueElement = (Element)queueNodes.item(j);
                    if (queueElement.getAttributeNode("Queue") != null) {
                        queueName = queueElement.getAttribute("Queue");
                    }
                    if (queueElement.getAttributeNode("Priority") != null) {
                        priority = VWScenarioPriorityType.stringToType(queueElement.getAttribute("Priority"));
                    }
                    if (queueElement.getAttributeNode("Index") != null) {
                        index = Integer.parseInt(queueElement.getAttribute("Index"));
                    }
                    VWScenarioQueueAssignment qa = roleDef.createQueueAssignment(queueName, priority, index);
                    if (priority != 1 || (fieldNodes = queueElement.getChildNodes()) == null) continue;
                    for (int l = 0; l < fieldNodes.getLength(); ++l) {
                        if (!fieldNodes.item(l).getNodeName().equals("PriorityField")) continue;
                        Element fieldElement = (Element)fieldNodes.item(l);
                        String name = fieldElement.getAttribute("Name");
                        int order = VWScenarioOrderType.stringToType(fieldElement.getAttribute("Order"));
                        index = Integer.parseInt(fieldElement.getAttribute("Index"));
                        int type = VWScenarioPriorityField.stringToType(fieldElement.getAttribute("Type"));
                        qa.createPriorityField(name, type, order, index);
                    }
                }
            }
        }
    }

    protected static void parseXMLShifts(Node shiftsNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (shiftsNode.getNodeType() != 1) {
            return;
        }
        Element shiftsElement = (Element)shiftsNode;
        NodeList childNodes = shiftsElement.getChildNodes();
        int numChilds = childNodes.getLength();
        if (childNodes != null && numChilds != 0) {
            VWScenarioShiftDefinition shiftDef = null;
            String shiftName = null;
            int type = -1;
            int units = -1;
            String duration = null;
            for (int i = 0; i < numChilds; ++i) {
                NodeList dayNodes;
                Node shiftNode = childNodes.item(i);
                if (!shiftNode.getNodeName().equals("Shift")) continue;
                Element shiftElement = (Element)shiftNode;
                if (shiftElement.getAttributeNode("Name") != null) {
                    shiftName = shiftElement.getAttribute("Name");
                }
                if (shiftElement.getAttributeNode("Type") != null) {
                    type = VWScenarioShiftType.stringToType(shiftElement.getAttribute("Type"));
                }
                if (shiftElement.getAttributeNode("Duration") != null) {
                    duration = shiftElement.getAttribute("Duration");
                }
                if (shiftElement.getAttributeNode("Units") != null) {
                    units = VWScenarioTimeUnitType.stringToType(shiftElement.getAttribute("Units"));
                }
                shiftDef = scenarioDef.createShift(shiftName);
                shiftDef.setShiftType(type);
                shiftDef.setDuration(new VWScenarioTimeDuration(duration, units));
                Element scheduleElement = VWScenarioXMLHandler.getFirstChildElement(shiftNode);
                if (scheduleElement == null) continue;
                if (scheduleElement.getNodeName().equals("Date")) {
                    shiftDef.setScheduleType(1);
                    if (scheduleElement.getAttributeNode("Value") == null) continue;
                    shiftDef.setStartTime(VWScenarioXMLHandler.convertStringToDate(scheduleElement.getAttribute("Value")).getTime());
                    continue;
                }
                if (scheduleElement.getNodeName().equals("Daily")) {
                    shiftDef.setScheduleType(2);
                    if (scheduleElement.getAttributeNode("Time") != null) {
                        shiftDef.setStartTime(VWScenarioXMLHandler.convertTimeValue(scheduleElement.getAttribute("Time")));
                    }
                    if (scheduleElement.getAttributeNode("Start") != null) {
                        shiftDef.setStartInterval(Integer.parseInt(scheduleElement.getAttribute("Start")));
                    }
                    if (scheduleElement.getAttributeNode("Every") != null) {
                        shiftDef.setEveryInterval(Integer.parseInt(scheduleElement.getAttribute("Every")));
                    }
                    if (scheduleElement.getAttributeNode("Occurrences") == null) continue;
                    shiftDef.setOccurrencesInterval(new Integer(scheduleElement.getAttribute("Occurrences")));
                    continue;
                }
                if (!scheduleElement.getNodeName().equals("Weekly")) continue;
                shiftDef.setScheduleType(3);
                if (scheduleElement.getAttributeNode("Time") != null) {
                    shiftDef.setStartTime(VWScenarioXMLHandler.convertTimeValue(scheduleElement.getAttribute("Time")));
                }
                if (scheduleElement.getAttributeNode("Start") != null) {
                    shiftDef.setStartInterval(Integer.parseInt(scheduleElement.getAttribute("Start")));
                }
                if (scheduleElement.getAttributeNode("Every") != null) {
                    shiftDef.setEveryInterval(Integer.parseInt(scheduleElement.getAttribute("Every")));
                }
                if (scheduleElement.getAttributeNode("Occurrences") != null) {
                    shiftDef.setOccurrencesInterval(new Integer(scheduleElement.getAttribute("Occurrences")));
                }
                if ((dayNodes = scheduleElement.getChildNodes()) == null) continue;
                int daysMask = 0;
                for (int j = 0; j < dayNodes.getLength(); ++j) {
                    Element dayElement;
                    if (!dayNodes.item(j).getNodeName().equals("Days") || (dayElement = (Element)dayNodes.item(j)).getAttributeNode("Name") == null) continue;
                    daysMask |= VWScenarioDayType.stringToType(dayElement.getAttribute("Name"));
                }
                shiftDef.setActiveDays(daysMask);
            }
        }
    }

    protected static void parseXMLActivityDefinition(Node activityDefNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (activityDefNode.getNodeType() != 1) {
            return;
        }
        NodeList processNodes = activityDefNode.getChildNodes();
        if (processNodes == null) {
            return;
        }
        for (int i = 0; i < processNodes.getLength(); ++i) {
            VWScenarioWorkflowDefinition swf = null;
            if (!processNodes.item(i).getNodeName().equals("ProcessRef")) continue;
            Element processElement = (Element)processNodes.item(i);
            swf = scenarioDef.getWorkflow(processElement.getAttribute("Name"));
            NodeList processChildNodes = processElement.getChildNodes();
            if (processChildNodes == null) continue;
            for (int j = 0; j < processChildNodes.getLength(); ++j) {
                if (processChildNodes.item(j).getNodeName().equals("DurationAcquireItem")) {
                    VWXML_CUR_parser.parseXMLDurationAcquireItem(processChildNodes.item(j), swf);
                }
                if (!processChildNodes.item(j).getNodeName().equals("MapRef")) continue;
                VWXML_CUR_parser.parseXMLMapReference(processChildNodes.item(j), swf);
            }
        }
    }

    protected static void parseXMLMapReference(Node mapRefNode, VWScenarioWorkflowDefinition swf) throws VWException, IOException, SAXException, ParseException {
        if (mapRefNode.getNodeType() != 1) {
            return;
        }
        if (!mapRefNode.getNodeName().equals("MapRef")) {
            return;
        }
        NodeList activityNodes = mapRefNode.getChildNodes();
        if (activityNodes == null) {
            return;
        }
        Element mapElement = (Element)mapRefNode;
        String mapName = mapElement.getAttribute("Name");
        for (int i = 0; i < activityNodes.getLength(); ++i) {
            Node activityNode = activityNodes.item(i);
            if (!activityNode.getNodeName().equals("ActivityRef")) continue;
            Element activityElement = (Element)activityNode;
            int stepId = Integer.parseInt(activityElement.getAttribute("Identifier"));
            VWScenarioStepSettings settings = swf.getStepSettings(mapName, stepId);
            settings.setRoutingType(1);
            settings.setKeepResource(Boolean.valueOf(activityElement.getAttribute("KeepResource")));
            NodeList activityChildNodes = activityNode.getChildNodes();
            if (activityChildNodes == null) continue;
            for (int j = 0; j < activityChildNodes.getLength(); ++j) {
                int units;
                String duration;
                if (activityChildNodes.item(j).getNodeType() != 1) continue;
                Element childElement = (Element)activityChildNodes.item(j);
                if (childElement.getNodeName().equals("Duration") || childElement.getNodeName().equals("fn:Duration")) {
                    duration = childElement.getAttribute("Value");
                    units = VWScenarioTimeUnitType.stringToType(childElement.getAttribute("Units"));
                    settings.setDuration(new VWScenarioTimeDuration(duration, units));
                    continue;
                }
                if (childElement.getNodeName().equals("Period")) {
                    duration = childElement.getAttribute("Value");
                    units = VWScenarioTimeUnitType.stringToType(childElement.getAttribute("Units"));
                    settings.setPeriodDuration(new VWScenarioTimeDuration(duration, units));
                    continue;
                }
                if (childElement.getNodeName().equals("Pause")) {
                    duration = childElement.getAttribute("Value");
                    units = VWScenarioTimeUnitType.stringToType(childElement.getAttribute("Units"));
                    settings.setPauseDuration(new VWScenarioTimeDuration(duration, units));
                    continue;
                }
                if (childElement.getNodeName().equals("Weights")) {
                    NodeList weightNodes = childElement.getChildNodes();
                    if (weightNodes == null) continue;
                    settings.setRoutingType(2);
                    for (int k = 0; k < weightNodes.getLength(); ++k) {
                        if (!weightNodes.item(k).getNodeName().equals("Weight")) continue;
                        Element weightElement = (Element)weightNodes.item(k);
                        int routeIndex = Integer.parseInt(weightElement.getAttribute("Route")) - 1;
                        int weight = (int)Float.parseFloat(weightElement.getAttribute("Weight"));
                        settings.setRouteWeightUsingIndex(routeIndex, weight);
                    }
                    continue;
                }
                if (!childElement.getNodeName().equals("FieldAssignmentsRef")) continue;
                VWXML_CUR_parser.parseXMLFieldAssignments(childElement, settings);
            }
        }
    }

    protected static void parseXMLFieldAssignments(Node fAssignmentsNode, VWScenarioStepSettings stepSettings) throws VWException, IOException, SAXException, ParseException {
        if (fAssignmentsNode.getNodeType() != 1) {
            return;
        }
        if (!fAssignmentsNode.getNodeName().equals("FieldAssignmentsRef")) {
            return;
        }
        stepSettings.setFieldAssignments(stepSettings.newFieldAssignments());
        VWScenarioFieldAssignments fAssignments = stepSettings.getFieldAssignments();
        VWScenarioInputFields inputFields = fAssignments.getInputFields();
        HashMap<String, VWFieldDefinition> fieldDefs = new HashMap<String, VWFieldDefinition>();
        NodeList childNodes = fAssignmentsNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            NodeList fieldWeightNodes;
            if (childNodes.item(i).getNodeType() != 1) continue;
            Element childElement = (Element)childNodes.item(i);
            if (childElement.getNodeName().equals("FieldInput")) {
                String fieldName = childElement.getAttribute("Name");
                boolean isRange = Boolean.valueOf(childElement.getAttribute("IsRange"));
                VWScenarioInputField inputField = inputFields.add(fieldName, isRange);
                fieldDefs.put(fieldName, inputField.getFieldDefinition());
                continue;
            }
            if (childElement.getNodeName().equals("FieldWeights")) {
                fieldWeightNodes = childElement.getChildNodes();
                if (fieldWeightNodes == null) continue;
                VWScenarioFieldAssignmentsEntry entry = fAssignments.addNewEntry();
                for (int j = 0; j < fieldWeightNodes.getLength(); ++j) {
                    if (fieldWeightNodes.item(j).getNodeType() != 1) continue;
                    Element fieldWeightElement = (Element)fieldWeightNodes.item(j);
                    if (fieldWeightElement.getNodeName().equals("InputValue")) {
                        String fieldName = fieldWeightElement.getAttribute("Name");
                        String inputValue = fieldWeightElement.getAttribute("Value");
                        VWFieldDefinition fieldDef = (VWFieldDefinition)fieldDefs.get(fieldName);
                        entry.setInputValue(fieldName, VWFieldType.stringToValue(inputValue, fieldDef.getFieldType(), fieldDef.isArray()), false);
                        continue;
                    }
                    if (!fieldWeightElement.getNodeName().equals("FieldOutput")) continue;
                    VWXML_CUR_parser.parseXMLFieldOutput(fieldWeightElement, entry, null);
                }
                continue;
            }
            if (!childElement.getNodeName().equals("DefaultWeights") || (fieldWeightNodes = childElement.getChildNodes()) == null) continue;
            for (int j = 0; j < fieldWeightNodes.getLength(); ++j) {
                VWXML_CUR_parser.parseXMLFieldOutput(fieldWeightNodes.item(j), null, fAssignments.getDefaultOutputs());
            }
        }
    }

    protected static void parseXMLFieldOutput(Node fieldWeightsNode, VWScenarioFieldAssignmentsEntry entry, VWScenarioOutputFields defaultOutputs) throws VWException, IOException, SAXException, ParseException {
        if (fieldWeightsNode.getNodeType() != 1) {
            return;
        }
        if (!fieldWeightsNode.getNodeName().equals("FieldOutput")) {
            return;
        }
        String fieldName = ((Element)fieldWeightsNode).getAttribute("Name");
        VWScenarioOutputField fieldOutput = null;
        fieldOutput = entry != null ? entry.getOutputs().add(fieldName) : defaultOutputs.add(fieldName);
        NodeList childNodes = fieldWeightsNode.getChildNodes();
        if (childNodes == null) {
            return;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!childNodes.item(i).getNodeName().equals("FieldWeight")) continue;
            Element childElement = (Element)childNodes.item(i);
            String value = childElement.getAttribute("Value");
            String weight = childElement.getAttribute("Weight");
            fieldOutput.add(value, weight);
        }
    }

    protected static void parseXMLDurationAcquireItem(Node durationAcquireItem, VWScenarioWorkflowDefinition swf) throws VWException, IOException, SAXException, ParseException {
        if (durationAcquireItem.getNodeType() != 1) {
            return;
        }
        if (!durationAcquireItem.getNodeName().equals("DurationAcquireItem")) {
            return;
        }
        Element durationElement = (Element)durationAcquireItem;
        float adjustFactor = 0.0f;
        Date startTime = null;
        Object endTime = null;
        String dataSource = null;
        if (durationElement.getAttributeNode("AdjustFactor") != null) {
            adjustFactor = Float.parseFloat(durationElement.getAttribute("AdjustFactor"));
        }
        if (durationElement.getAttributeNode("DataSource") != null) {
            dataSource = durationElement.getAttribute("DataSource");
        }
        NodeList durationTimeNodes = durationElement.getChildNodes();
        for (int k = 0; k < durationTimeNodes.getLength(); ++k) {
            if (durationTimeNodes.item(k).getNodeName().equals("DurationStartTime")) {
                startTime = (Date)VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getFirstChildElement(durationTimeNodes.item(k)));
                continue;
            }
            if (!durationTimeNodes.item(k).getNodeName().equals("DurationEndTime")) continue;
            endTime = VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getFirstChildElement(durationTimeNodes.item(k)));
        }
        swf.setDurationPattern(new VWScenarioDurationPattern(startTime, endTime, adjustFactor, dataSource));
    }

    protected static void parseXMLArrivalDefinition(Node arrivalDefNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (arrivalDefNode.getNodeType() != 1) {
            return;
        }
        if (!arrivalDefNode.hasChildNodes()) {
            return;
        }
        NodeList childNodes = arrivalDefNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (childNodes.item(i).getNodeName().equals("Arrivals")) {
                VWXML_CUR_parser.parseXMLArrivalItems(childNodes.item(i), scenarioDef);
                continue;
            }
            if (!childNodes.item(i).getNodeName().equals("AcquireItems")) continue;
            VWXML_CUR_parser.parseXMLAcquireItems(childNodes.item(i), scenarioDef);
        }
    }

    protected static void parseXMLAcquireItems(Node acquireItemsNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (acquireItemsNode.getNodeType() != 1) {
            return;
        }
        if (!acquireItemsNode.hasChildNodes()) {
            return;
        }
        NodeList aquireItemNodes = acquireItemsNode.getChildNodes();
        if (aquireItemNodes != null) {
            for (int i = 0; i < aquireItemNodes.getLength(); ++i) {
                NodeList itemChildNodes;
                if (!aquireItemNodes.item(i).getNodeName().equals("AcquireItem")) continue;
                String arrivalName = null;
                String processName = null;
                Object startTime = null;
                Date acquireStartTime = null;
                Object acquireEndTime = null;
                float adjustFactor = 0.0f;
                String dataSource = null;
                Element aquireElement = (Element)aquireItemNodes.item(i);
                if (aquireElement.getAttributeNode("Name") != null) {
                    arrivalName = aquireElement.getAttribute("Name");
                }
                if (aquireElement.getAttributeNode("AdjustFactor") != null) {
                    adjustFactor = Float.parseFloat(aquireElement.getAttribute("AdjustFactor"));
                }
                if (aquireElement.getAttributeNode("DataSource") != null) {
                    dataSource = aquireElement.getAttribute("DataSource");
                }
                if ((itemChildNodes = aquireItemNodes.item(i).getChildNodes()) != null) {
                    for (int j = 0; j < itemChildNodes.getLength(); ++j) {
                        if (itemChildNodes.item(j).getNodeType() != 1) continue;
                        Element element = (Element)itemChildNodes.item(j);
                        if (element.getNodeName().equals("Process")) {
                            if (element.getAttributeNode("Name") == null) continue;
                            processName = element.getAttribute("Name");
                            continue;
                        }
                        if (element.getNodeName().equals("SimStartTime") && element.hasChildNodes()) {
                            startTime = VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getFirstChildElement(element));
                            continue;
                        }
                        if (element.getNodeName().equals("StartTime") && element.hasChildNodes()) {
                            acquireStartTime = (Date)VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getFirstChildElement(element));
                            continue;
                        }
                        if (!element.getNodeName().equals("EndTime") || !element.hasChildNodes()) continue;
                        acquireEndTime = VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getFirstChildElement(element));
                    }
                }
                scenarioDef.getWorkflow(processName).createArrival(arrivalName, startTime, acquireStartTime, acquireEndTime, adjustFactor, dataSource);
            }
        }
    }

    protected static void parseXMLArrivalItems(Node arrivalItemsNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException, ParseException {
        if (arrivalItemsNode.getNodeType() != 1) {
            return;
        }
        if (!arrivalItemsNode.hasChildNodes()) {
            return;
        }
        NodeList arrivalNodes = arrivalItemsNode.getChildNodes();
        if (arrivalNodes != null) {
            for (int i = 0; i < arrivalNodes.getLength(); ++i) {
                if (!arrivalNodes.item(i).getNodeName().equals("Arrival")) continue;
                String arrivalName = null;
                String processName = null;
                Object startTime = null;
                String[][] fieldAssignments = null;
                VWScenarioArrivalOccurrence occurrence = null;
                VWScenarioArrivalRecurrence recurrence = null;
                Element arrivalElement = (Element)arrivalNodes.item(i);
                if (arrivalElement.getAttributeNode("Name") != null) {
                    arrivalName = arrivalElement.getAttribute("Name");
                }
                NodeList arrivalChildNodes = arrivalNodes.item(i).getChildNodes();
                for (int j = 0; j < arrivalChildNodes.getLength(); ++j) {
                    if (arrivalChildNodes.item(j).getNodeType() != 1) continue;
                    Element element = (Element)arrivalChildNodes.item(j);
                    if (element.getNodeName().equals("Process")) {
                        if (element.getAttributeNode("Name") == null) continue;
                        processName = element.getAttribute("Name");
                        continue;
                    }
                    if (element.getNodeName().equals("StartTime") && element.hasChildNodes()) {
                        startTime = VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getNodeNamed(element, "TimeExpression"));
                        continue;
                    }
                    if (element.getNodeName().equals("Occurrence") && element.hasChildNodes()) {
                        occurrence = new VWScenarioArrivalOccurrence();
                        if (element.getAttributeNode("Quantity") != null) {
                            occurrence.setQuantity(element.getAttribute("Quantity"));
                        }
                        if (element.getAttributeNode("Type") != null) {
                            occurrence.setType(VWScenarioOccurrenceType.stringToType(element.getAttribute("Type")));
                        }
                        VWXML_CUR_parser.parseXMLArrivalCycle(VWScenarioXMLHandler.getNodeNamed(element, "Cycle"), occurrence);
                        continue;
                    }
                    if (element.getNodeName().equals("Recurrence") && element.hasChildNodes()) {
                        recurrence = new VWScenarioArrivalRecurrence();
                        VWXML_CUR_parser.parseXMLArrivalCycle(VWScenarioXMLHandler.getNodeNamed(element, "Cycle"), recurrence);
                        continue;
                    }
                    if (!element.getNodeName().equals("FieldValues") || !element.hasChildNodes()) continue;
                    ArrayList<String[]> fields = new ArrayList<String[]>();
                    NodeList fieldNodes = element.getChildNodes();
                    for (int k = 0; k < fieldNodes.getLength(); ++k) {
                        if (!fieldNodes.item(k).getNodeName().equals("FieldValue")) continue;
                        Element fieldElement = (Element)fieldNodes.item(k);
                        String[] field = new String[]{null, null};
                        if (fieldElement.getAttributeNode("Name") != null) {
                            field[0] = fieldElement.getAttribute("Name");
                        }
                        if (fieldElement.getAttributeNode("Value") != null) {
                            field[1] = fieldElement.getAttribute("Value");
                        }
                        fields.add(field);
                    }
                    fieldAssignments = (String[][])fields.toArray((T[])new String[0][0]);
                }
                if (processName == null) continue;
                VWScenarioWorkflowDefinition swfDef = scenarioDef.getWorkflow(processName);
                swfDef.createArrival(arrivalName, startTime, occurrence, recurrence, fieldAssignments);
            }
        }
    }

    protected static void parseXMLArrivalCycle(Node cycleNode, IVWScenarioArrivalCycle cycle) throws VWException, IOException, SAXException, ParseException {
        if (cycleNode.getNodeType() != 1) {
            return;
        }
        if (!cycleNode.getNodeName().equals("Cycle")) {
            return;
        }
        NodeList cycleChildNodes = cycleNode.getChildNodes();
        if (cycleChildNodes != null && cycleChildNodes.getLength() != 0) {
            for (int k = 0; k < cycleChildNodes.getLength(); ++k) {
                Element maxElement;
                Node cycleChildNode = cycleChildNodes.item(k);
                if (cycleChildNode.getNodeName().equals("TimeExpression")) {
                    cycle.setTimeInterval(VWXML_CUR_parser.parseXMLTimeExpression(cycleChildNode));
                    continue;
                }
                if (cycleChildNode.getNodeName().equals("EndTime") && cycleChildNode.hasChildNodes()) {
                    cycle.setEndTime(VWXML_CUR_parser.parseXMLTimeExpression(VWScenarioXMLHandler.getFirstChildElement(cycleChildNode)));
                    continue;
                }
                if (!cycleChildNode.getNodeName().equals("MaxCount") || (maxElement = (Element)cycleChildNode).getAttributeNode("Value") == null) continue;
                cycle.setMaxCount(maxElement.getAttribute("Value"));
            }
        }
    }

    protected static void parseXMLWorkflowDefinitions(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        int numChilds = childNodes.getLength();
        if (childNodes != null && numChilds != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node theNode = childNodes.item(i);
                if (!theNode.getNodeName().equals("WorkFlowDefinition")) continue;
                VWXML_CUR_parser.parseXMLWorkflowDefinition(theNode, scenarioDef);
            }
        }
    }

    protected static void parseXMLWorkflowDefinition(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        VWWorkflowDefinition wfDef = VWXMLHandler.parseXMLWorkFlow(ele);
        scenarioDef.importWorkflow(wfDef);
    }

    protected static void parseXPDLWorkflowDefinitions(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        int numChilds = childNodes.getLength();
        if (childNodes != null && numChilds != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node theNode = childNodes.item(i);
                if (!theNode.getNodeName().equals("WorkflowProcess")) continue;
                VWXML_CUR_parser.parseXPDLWorkflowDefinition(theNode, scenarioDef);
            }
        }
    }

    protected static void parseXPDLWorkflowDefinition(Node aNode, VWScenarioDefinition scenarioDef) throws VWException, IOException, SAXException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        VWWorkflowDefinition wfDef = VWXMLHandler.parseXPDLWorkFlow(ele);
        scenarioDef.importWorkflow(wfDef);
    }

    protected static Object parseXMLTimeExpression(Node aNode) throws VWException, IOException, SAXException, ParseException {
        if (aNode == null) {
            return null;
        }
        if (aNode.getNodeType() != 1) {
            return null;
        }
        if (!aNode.getNodeName().equals("TimeExpression") && !aNode.getNodeName().equals("ActTimeExpression")) {
            return null;
        }
        NodeList childNodes = ((Element)aNode).getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node theNode = childNodes.item(i);
                if (theNode.getNodeType() != 1) continue;
                Element element = (Element)theNode;
                if ((theNode.getNodeName().equals("Calendar") || theNode.getNodeName().equals("ActCalendar")) && element.getAttributeNode("Date") != null) {
                    return VWScenarioXMLHandler.convertStringToDate(element.getAttribute("Date"));
                }
                if (theNode.getNodeName().equals("Day") || theNode.getNodeName().equals("ActDay")) {
                    String offsetValue = null;
                    int units = 4;
                    int time = 0;
                    if (element.getAttributeNode("Value") != null) {
                        offsetValue = element.getAttribute("Value");
                    }
                    if (element.getAttributeNode("Time") != null) {
                        time = VWScenarioXMLHandler.convertTimeValue(element.getAttribute("Time"));
                    }
                    return new VWScenarioTimeOffset(offsetValue, units, time);
                }
                if (!theNode.getNodeName().equals("Time") && !theNode.getNodeName().equals("ActTime")) continue;
                String durationValue = null;
                int units = 1;
                if (element.getAttributeNode("Value") != null) {
                    durationValue = element.getAttribute("Value");
                }
                if (element.getAttributeNode("Units") != null) {
                    units = VWScenarioTimeUnitType.stringToType(element.getAttribute("Units"));
                }
                return new VWScenarioTimeDuration(durationValue, units);
            }
        }
        return null;
    }

    protected static void parseXMLConfigurations(Node configurationsNode, VWScenarioDefinition scenarioDef) throws VWException {
        if (configurationsNode == null) {
            return;
        }
        if (configurationsNode.getNodeType() != 1) {
            return;
        }
        if (!configurationsNode.getNodeName().equals("ConfigurationDefinitions")) {
            return;
        }
        NodeList configNodes = configurationsNode.getChildNodes();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            if (!configNodes.item(i).getNodeName().equals("Configuration")) continue;
            Node configNode = configNodes.item(i);
            Element configElement = (Element)configNode;
            String serviceName = null;
            int region = 1;
            if (configElement.getAttributeNode("SystemName") != null) {
                serviceName = configElement.getAttribute("SystemName");
            }
            if (configElement.getAttributeNode("RegionId") != null) {
                region = Integer.parseInt(configElement.getAttribute("RegionId"));
            }
            VWScenarioConfiguration scenarioConfig = new VWScenarioConfiguration(serviceName, region);
            NodeList childNodes = configNode.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                if (!childNodes.item(j).getNodeName().equals("Queues")) continue;
                VWXML_CUR_parser.parseXMLQueueDefinitions(childNodes.item(j), scenarioConfig);
            }
            scenarioDef.setConfiguration(scenarioConfig);
            break;
        }
    }

    protected static void parseXMLQueueDefinitions(Node node, VWScenarioConfiguration scenarioConfig) throws VWException {
        if (node == null) {
            return;
        }
        if (node.getNodeType() != 1) {
            return;
        }
        if (!node.getNodeName().equals("Queues")) {
            return;
        }
        NodeList queueNodes = node.getChildNodes();
        for (int i = 0; i < queueNodes.getLength(); ++i) {
            Node queueNode = queueNodes.item(i);
            if (!queueNode.getNodeName().equals("Queue")) continue;
            Element queueElement = (Element)queueNode;
            String queueName = null;
            int queueId = -1;
            if (queueElement.getAttributeNode("Name") != null) {
                queueName = queueElement.getAttribute("Name");
            }
            if (queueElement.getAttributeNode("Id") != null) {
                queueId = Integer.parseInt(queueElement.getAttribute("Id"));
            }
            VWScenarioQueueDefinition queueDef = scenarioConfig.createQueue(queueName, queueId);
            NodeList queueChildNodes = queueNode.getChildNodes();
            if (queueChildNodes == null) continue;
            for (int j = 0; j < queueChildNodes.getLength(); ++j) {
                if (!queueChildNodes.item(j).getNodeName().equals("Operations")) continue;
                NodeList opNodes = queueChildNodes.item(j).getChildNodes();
                for (int k = 0; k < opNodes.getLength(); ++k) {
                    Node opNode = opNodes.item(k);
                    if (!opNode.getNodeName().equals("Operation")) continue;
                    Element opElement = (Element)opNode;
                    String opName = null;
                    int opId = -1;
                    if (opElement.getAttributeNode("Name") != null) {
                        opName = opElement.getAttribute("Name");
                    }
                    if (opElement.getAttributeNode("Id") != null) {
                        opId = Integer.parseInt(opElement.getAttribute("Id"));
                    }
                    queueDef.createOperation(opName, opId);
                }
            }
        }
    }
}

